<?php

namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * CreatorStagesCompanyConfirm
 *
 * @ORM\Table(name="creator_stages_company_confirm")
 * @ORM\Entity(repositoryClass="VM\ApiBundle\Repository\CreatorStagesCompanyConfirmRepository")
 *
 * @ExclusionPolicy("all")
 */
class CreatorStagesCompanyConfirm
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"list","partsList","details"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="company_id", type="integer")
     *
     */
    private $companyId;

    /**
     * @ORM\ManyToOne(targetEntity="Company",inversedBy="creatorStagesCompanyConfirms")
     * @ORM\JoinColumn(name="company_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $company;

    /**
     * @var integer
     *
     * @ORM\Column(name="stage_id", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $stageId;

    /**
     * @ORM\ManyToOne(targetEntity="CreatorStages",inversedBy="creatorStagesCompanyConfirms")
     * @ORM\JoinColumn(name="stage_id", referencedColumnName="id")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $stage;

    /**
     * @ORM\OneToMany(targetEntity="UserToken", mappedBy="creatorStagesCompanyConfirm")
     *
     * @Expose
     * @AnnotationGroups({"companyDetails"})
     */
    private $tokens;






    /**
     * Constructor
     */
    public function __construct()
    {
        $this->tokens = new \Doctrine\Common\Collections\ArrayCollection();
    }
    
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set companyId
     *
     * @param integer $companyId
     * @return CreatorStagesCompanyConfirm
     */
    public function setCompanyId($companyId)
    {
        $this->companyId = $companyId;
    
        return $this;
    }

    /**
     * Get companyId
     *
     * @return integer 
     */
    public function getCompanyId()
    {
        return $this->companyId;
    }

    /**
     * Set stageId
     *
     * @param integer $stageId
     * @return CreatorStagesCompanyConfirm
     */
    public function setStageId($stageId)
    {
        $this->stageId = $stageId;
    
        return $this;
    }

    /**
     * Get stageId
     *
     * @return integer 
     */
    public function getStageId()
    {
        return $this->stageId;
    }

    /**
     * Set company
     *
     * @param \VM\ApiBundle\Entity\Company $company
     * @return CreatorStagesCompanyConfirm
     */
    public function setCompany(\VM\ApiBundle\Entity\Company $company = null)
    {
        $this->company = $company;
    
        return $this;
    }

    /**
     * Get company
     *
     * @return \VM\ApiBundle\Entity\Company 
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * Set stage
     *
     * @param \VM\ApiBundle\Entity\CreatorStages $stage
     * @return CreatorStagesCompanyConfirm
     */
    public function setStage(\VM\ApiBundle\Entity\CreatorStages $stage = null)
    {
        $this->stage = $stage;
    
        return $this;
    }

    /**
     * Get stage
     *
     * @return \VM\ApiBundle\Entity\CreatorStages 
     */
    public function getStage()
    {
        return $this->stage;
    }

    /**
     * Add tokens
     *
     * @param \VM\ApiBundle\Entity\UserToken $tokens
     * @return CreatorStagesCompanyConfirm
     */
    public function addToken(\VM\ApiBundle\Entity\UserToken $tokens)
    {
        $this->tokens[] = $tokens;
    
        return $this;
    }

    /**
     * Remove tokens
     *
     * @param \VM\ApiBundle\Entity\UserToken $tokens
     */
    public function removeToken(\VM\ApiBundle\Entity\UserToken $tokens)
    {
        $this->tokens->removeElement($tokens);
    }

    /**
     * Get tokens
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTokens()
    {
        return $this->tokens;
    }
}